unit u_wordClock;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes,
  System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Objects,
  FMX.Controls.Presentation, FMX.StdCtrls;

type
  TfrmWordClock = class(TForm)
    lblHeader: TLabel;
    shpBackground: TRectangle;
    lblSeconds: TLabel;
    lblMinutes: TLabel;
    lblHours: TLabel;
    tmrTimer: TTimer;
    lblDate: TLabel;
    procedure tmrTimerTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWordClock: TfrmWordClock;

implementation

{$R *.fmx}

procedure TfrmWordClock.tmrTimerTimer(Sender: TObject);
var
  tTime: TDateTime;
  sTimeOfDay: String;
  iHours: Integer;
begin
  //lblSeconds.Caption := FormatDateTime('s', Now) + ' seconds and';//For older versions of Delphi
  lblSeconds.Text := FormatDateTime('s', Now) + ' seconds and';
  //lblMinutes.Caption := FormatDateTime('n', Now) + ' minutes past'; //For older versions of Delphi
  lblMinutes.Text := FormatDateTime('n', Now) + ' minutes past';
  tTime := Now - Date;

  if tTime < 0.5 then
    sTimeOfDay := ' in the morning';
  if (tTime >= 0.5) and (tTime < 0.75) then
    sTimeOfDay := ' in the afternoon';
  if tTime >= 0.75 then
    sTimeOfDay := ' in the evening';

  iHours := StrToInt(FormatDateTime('h', tTime)) mod 12;
  if iHours = 0 then
    iHours := 12;

  //lblHours.Caption := IntToStr(iHours) + sTimeOfDay; //For older versions of Delhi
  lblHours.Text := IntToStr(iHours) + sTimeOfDay;
end;

end.
